/*
 * Decompiled with CFR 0.152.
 */
package com.intel.bluetooth;

import com.intel.bluetooth.BluetoothStack;
import com.intel.bluetooth.DebugLog;
import com.intel.bluetooth.DeviceInquiryRunnable;
import com.intel.bluetooth.DeviceInquiryThread;
import com.intel.bluetooth.EmulatorLocalDevice;
import com.intel.bluetooth.RemoteDeviceHelper;
import com.intel.bluetooth.emu.DeviceDescriptor;
import java.util.Random;
import java.util.Vector;
import javax.bluetooth.BluetoothStateException;
import javax.bluetooth.DeviceClass;
import javax.bluetooth.DiscoveryListener;
import javax.bluetooth.RemoteDevice;

class EmulatorDeviceInquiry
implements DeviceInquiryRunnable {
    private static final int DISCOVERY_DURATION_ALWAYS = 200;
    private static final int DISCOVERY_DURATION_MINIMUM = 500;
    private EmulatorLocalDevice localDevice;
    private BluetoothStack bluetoothStack;
    private DiscoveryListener discoveryListener;
    private boolean deviceInquiryCanceled = false;
    private Object canceledEvent = new Object();
    private static Random rnd;

    EmulatorDeviceInquiry(EmulatorLocalDevice localDevice, BluetoothStack bluetoothStack, DiscoveryListener discoveryListener) {
        this.localDevice = localDevice;
        this.bluetoothStack = bluetoothStack;
        this.discoveryListener = discoveryListener;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int runDeviceInquiry(DeviceInquiryThread startedNotify, int accessCode, DiscoveryListener listener) throws BluetoothStateException {
        try {
            DeviceDescriptor[] devices = this.localDevice.getDeviceManagerService().getDiscoveredDevices(this.localDevice.getAddress());
            startedNotify.deviceInquiryStartedCallback();
            long start = System.currentTimeMillis();
            while (devices.length == 0 && this.randomWait(start, -1)) {
                devices = this.updateDiscoveredDevices(devices);
            }
            int reportedIndex = 0;
            while (this.randomWait(start, reportedIndex) || reportedIndex < devices.length) {
                if (this.deviceInquiryCanceled) {
                    int n = 5;
                    return n;
                }
                if (reportedIndex < devices.length) {
                    DeviceDescriptor d = devices[reportedIndex];
                    d = this.localDevice.getDeviceManagerService().getDeviceDescriptor(d.getAddress());
                    ++reportedIndex;
                    RemoteDevice remoteDevice = RemoteDeviceHelper.createRemoteDevice((BluetoothStack)this.bluetoothStack, (long)d.getAddress(), (String)d.getName(), (boolean)false);
                    DeviceClass cod = new DeviceClass(d.getDeviceClass());
                    DebugLog.debug((String)"deviceDiscovered address", (String)remoteDevice.getBluetoothAddress());
                    DebugLog.debug((String)"deviceDiscovered deviceClass", (Object)cod);
                    listener.deviceDiscovered(remoteDevice, cod);
                }
                devices = this.updateDiscoveredDevices(devices);
            }
            if (this.deviceInquiryCanceled) {
                int n = 5;
                return n;
            }
            int n = 0;
            return n;
        }
        finally {
            this.bluetoothStack.cancelInquiry(this.discoveryListener);
        }
    }

    private DeviceDescriptor[] updateDiscoveredDevices(DeviceDescriptor[] devices) {
        int i;
        DeviceDescriptor[] newDevices = this.localDevice.getDeviceManagerService().getDiscoveredDevices(this.localDevice.getAddress());
        Vector<DeviceDescriptor> discoveredDevice = new Vector<DeviceDescriptor>();
        for (i = 0; i < devices.length; ++i) {
            discoveredDevice.addElement(devices[i]);
        }
        block1: for (i = 0; i < newDevices.length; ++i) {
            for (int k = 0; k < devices.length; ++k) {
                if (newDevices[i].getAddress() == devices[k].getAddress()) continue block1;
            }
            discoveredDevice.addElement(newDevices[i]);
        }
        return discoveredDevice.toArray(new DeviceDescriptor[discoveredDevice.size()]);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean randomWait(long start, int device) {
        long duration = this.localDevice.getConfiguration().getDeviceInquiryDuration() * 1000;
        if (duration <= 0L) {
            duration = 500L;
        }
        long now = System.currentTimeMillis();
        if (duration == 0L || now > start + duration) {
            return false;
        }
        long timeout = duration / 7L;
        if (this.localDevice.getConfiguration().isDeviceInquiryRandomDelay()) {
            long timeleft;
            if (rnd == null) {
                rnd = new Random();
            }
            if ((timeleft = start + duration - now) > 0L) {
                timeout = rnd.nextInt((int)timeleft);
            }
        }
        if (device == 0) {
            timeout += 200L;
        }
        if (now + timeout > start + duration) {
            timeout = start + duration - now;
        }
        if (timeout <= 0L) {
            return true;
        }
        Object object = this.canceledEvent;
        synchronized (object) {
            try {
                this.canceledEvent.wait(timeout);
            }
            catch (InterruptedException e) {
                this.deviceInquiryCanceled = true;
            }
        }
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    boolean cancelInquiry(DiscoveryListener listener) {
        if (this.discoveryListener != listener) {
            return false;
        }
        this.deviceInquiryCanceled = true;
        Object object = this.canceledEvent;
        synchronized (object) {
            this.canceledEvent.notifyAll();
        }
        return true;
    }

    public void deviceDiscoveredCallback(DiscoveryListener listener, long deviceAddr, int deviceClass, String deviceName, boolean paired) {
    }
}

