/*
 * Decompiled with CFR 0.152.
 */
package com.intel.bluetooth;

import com.intel.bluetooth.EmulatorLocalDevice;
import com.intel.bluetooth.emu.DeviceCommand;
import java.io.File;
import java.io.FileWriter;
import java.io.IOException;
import java.io.OutputStreamWriter;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.Map;

class EmulatorCommandReceiver
extends Thread {
    private EmulatorLocalDevice localDevice;
    private boolean stoped = false;

    EmulatorCommandReceiver(EmulatorLocalDevice localDevice) {
        super("BlueCoveEmulatorCommandReceiver");
        this.localDevice = localDevice;
    }

    void shutdownReceiver() {
        this.stoped = true;
    }

    public void run() {
        DeviceCommand cmd;
        while (!this.stoped && (cmd = this.localDevice.getDeviceManagerService().pollCommand(this.localDevice.getAddress())) != null) {
            this.execute(cmd);
        }
    }

    private void execute(DeviceCommand command) {
        switch (command.getType()) {
            case keepAlive: {
                break;
            }
            case chagePowerState: {
                this.localDevice.setLocalDevicePower((Boolean)command.getParameters()[0]);
                break;
            }
            case updateLocalDeviceProperties: {
                this.localDevice.updateLocalDeviceProperties();
                break;
            }
            case createThreadDumpStdOut: {
                EmulatorCommandReceiver.threadDump(false);
                break;
            }
            case createThreadDumpFile: {
                EmulatorCommandReceiver.threadDump(true);
                break;
            }
            case shutdownJVM: {
                System.exit(0);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    static void threadDump(boolean useFile) {
        SimpleDateFormat fmt = new SimpleDateFormat("MM-dd_HH-mm-ss");
        OutputStreamWriter out = null;
        try {
            File file = null;
            if (useFile) {
                file = new File("ThreadDump-" + fmt.format(new Date()) + ".log");
                out = new FileWriter(file);
            } else {
                out = new OutputStreamWriter(System.out);
            }
            Map<Thread, StackTraceElement[]> traces = Thread.getAllStackTraces();
            for (Map.Entry<Thread, StackTraceElement[]> entry : traces.entrySet()) {
                Thread thread = entry.getKey();
                out.write("Thread= " + thread.getName() + " " + (thread.isDaemon() ? "daemon" : "") + " prio=" + thread.getPriority() + "id=" + thread.getId() + " " + (Object)((Object)thread.getState()));
                out.write("\n");
                StackTraceElement[] ste = entry.getValue();
                for (int i = 0; i < ste.length; ++i) {
                    out.write("\t");
                    out.write(ste[i].toString());
                    out.write("\n");
                }
                out.write("---------------------------------\n");
            }
            out.close();
            out = null;
            if (useFile) {
                System.err.println("Full ThreadDump created " + file.getAbsolutePath());
            }
        }
        catch (IOException ignore) {
        }
        finally {
            try {
                out.close();
            }
            catch (IOException ignore) {}
        }
    }
}

