/*
 * Decompiled with CFR 0.152.
 */
package com.intel.bluetooth.obex;

import com.intel.bluetooth.obex.OBEXOperation;
import com.intel.bluetooth.obex.OBEXOperationReceive;
import java.io.IOException;
import java.io.InputStream;

class OBEXOperationInputStream
extends InputStream {
    private final OBEXOperation operation;
    private byte[] buffer = new byte[256];
    private int readPos = 0;
    private int appendPos = 0;
    private Object lock = new Object();
    private boolean isClosed = false;
    private boolean eofReceived = false;

    OBEXOperationInputStream(OBEXOperation op) {
        this.operation = op;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int read() throws IOException {
        if (this.isClosed) {
            throw new IOException("Stream closed");
        }
        if (this.operation.isClosed() && this.appendPos == this.readPos) {
            return -1;
        }
        Object object = this.lock;
        synchronized (object) {
            while (!this.eofReceived && this.operation instanceof OBEXOperationReceive && !this.isClosed && !this.operation.isClosed() && this.appendPos == this.readPos) {
                ((OBEXOperationReceive)this.operation).receiveData(this);
            }
            if (this.appendPos == this.readPos) {
                return -1;
            }
            return this.buffer[this.readPos++] & 0xFF;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int available() throws IOException {
        Object object = this.lock;
        synchronized (object) {
            return this.appendPos - this.readPos;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void close() throws IOException {
        this.isClosed = true;
        Object object = this.lock;
        synchronized (object) {
            this.lock.notifyAll();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void appendData(byte[] b, boolean eof) {
        if (this.isClosed || this.eofReceived) {
            return;
        }
        Object object = this.lock;
        synchronized (object) {
            if (eof) {
                this.eofReceived = true;
            }
            if (b != null && b.length != 0) {
                if (this.appendPos + b.length > this.buffer.length) {
                    int newSize = (b.length + (this.appendPos - this.readPos)) * 2;
                    if (newSize < this.buffer.length) {
                        newSize = this.buffer.length;
                    }
                    byte[] newBuffer = new byte[newSize];
                    System.arraycopy(this.buffer, this.readPos, newBuffer, 0, this.appendPos - this.readPos);
                    this.buffer = newBuffer;
                    this.appendPos -= this.readPos;
                    this.readPos = 0;
                }
                System.arraycopy(b, 0, this.buffer, this.appendPos, b.length);
                this.appendPos += b.length;
            }
            this.lock.notifyAll();
        }
    }
}

