/*
 * Decompiled with CFR 0.152.
 */
import java.io.IOException;
import java.util.Date;
import java.util.HashSet;
import java.util.Set;
import javax.bluetooth.DeviceClass;
import javax.bluetooth.DiscoveryListener;
import javax.bluetooth.LocalDevice;
import javax.bluetooth.RemoteDevice;
import javax.bluetooth.ServiceRecord;

public class RemoteDeviceDiscovery {
    private static boolean debug = false;
    public static final Set<RemoteDevice> devicesDiscovered = new HashSet<RemoteDevice>();

    public static void runDiscovery(boolean verbose) throws IOException, InterruptedException {
        System.out.println("#Searching for devices");
        RemoteDeviceDiscovery.findDevices();
        for (RemoteDevice d : devicesDiscovered) {
            System.out.println("-," + RemoteDeviceDiscovery.deviceName(d, verbose));
        }
        System.out.println("#Found " + devicesDiscovered.size() + " device(s)");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void findDevices() throws IOException, InterruptedException {
        final Object inquiryCompletedEvent = new Object();
        devicesDiscovered.clear();
        DiscoveryListener listener = new DiscoveryListener(){

            public void deviceDiscovered(RemoteDevice btDevice, DeviceClass cod) {
                if (debug) {
                    System.out.println("#Device " + btDevice.getBluetoothAddress() + " found");
                }
                devicesDiscovered.add(btDevice);
                try {
                    if (debug) {
                        System.out.println("#     name " + btDevice.getFriendlyName(false));
                    }
                }
                catch (IOException iOException) {
                    // empty catch block
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            public void inquiryCompleted(int discType) {
                if (debug) {
                    System.out.println("#Device Inquiry completed!");
                }
                Object object = inquiryCompletedEvent;
                synchronized (object) {
                    inquiryCompletedEvent.notifyAll();
                }
            }

            public void serviceSearchCompleted(int transID, int respCode) {
            }

            public void servicesDiscovered(int transID, ServiceRecord[] servRecord) {
                if (debug) {
                    System.out.println("#servicesDiscovered");
                }
            }
        };
        Object object = inquiryCompletedEvent;
        synchronized (object) {
            boolean started;
            LocalDevice ld = LocalDevice.getLocalDevice();
            if (debug) {
                System.out.println("#My Name is:" + ld.getFriendlyName());
            }
            if (started = LocalDevice.getLocalDevice().getDiscoveryAgent().startInquiry(10390323, listener)) {
                if (debug) {
                    System.out.println("#wait for device inquiry to complete...");
                }
                inquiryCompletedEvent.wait();
                if (debug) {
                    System.out.println("#" + devicesDiscovered.size() + " device(s) found");
                }
            }
        }
    }

    public static Set<RemoteDevice> getDevices() {
        return devicesDiscovered;
    }

    public static String deviceName(RemoteDevice d, boolean verbose) {
        String name;
        String address;
        block5: {
            address = d.getBluetoothAddress();
            name = "";
            try {
                name = d.getFriendlyName(false);
            }
            catch (IOException e) {
                if (verbose) {
                    System.out.println("#Error: " + e.getMessage());
                }
                try {
                    name = d.getFriendlyName(false);
                }
                catch (IOException e2) {
                    if (!verbose) break block5;
                    System.out.println("#Error: " + e2.getMessage());
                }
            }
        }
        return String.valueOf(new Date().getTime()) + ", \"" + BluCatUtil.clean(address) + "\", " + "\"" + BluCatUtil.clean(name) + "\", " + "Trusted:" + d.isTrustedDevice() + ", " + "Encrypted:" + d.isEncrypted();
    }
}

