/*
 * Decompiled with CFR 0.152.
 */
import com.intel.bluetooth.BluetoothConsts;
import java.io.FilterInputStream;
import java.io.FilterOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.Date;
import java.util.zip.GZIPInputStream;
import java.util.zip.GZIPOutputStream;
import javax.bluetooth.LocalDevice;
import javax.bluetooth.ServiceRecord;
import javax.bluetooth.UUID;
import javax.microedition.io.Connection;
import javax.microedition.io.Connector;
import javax.microedition.io.StreamConnection;
import javax.microedition.io.StreamConnectionNotifier;

public class RFCOMMServer {
    public static void startServerRFCOMM(String exec, boolean verbose, boolean keepalive, boolean zip) throws IOException {
        String url = "btspp://localhost:" + BluetoothConsts.RFCOMM_PROTOCOL_UUID + ";name=BlueCatPipe;authenticate=false;encrypt=false;master=true";
        if (verbose) {
            System.err.println("#Creating RFCOMM server");
        }
        StreamConnectionNotifier service = (StreamConnectionNotifier)Connector.open((String)url);
        ServiceRecord rec = LocalDevice.getLocalDevice().getRecord((Connection)service);
        String remoteUrl = rec.getConnectionURL(0, false);
        remoteUrl = remoteUrl.substring(0, remoteUrl.indexOf(";"));
        if (verbose) {
            System.err.println("#" + new Date() + " - Listening at " + remoteUrl);
        }
        RFCOMMServer.handleStreamConnection(service, exec, verbose, keepalive, zip);
    }

    public static void startServerUuid(String exec, String uuidValue, boolean verbose, boolean keepalive, boolean zip) throws IOException {
        uuidValue = uuidValue.replace("-", "");
        UUID uuid = new UUID(uuidValue, false);
        String url = "btspp://localhost:" + uuid.toString() + ";name=BlueCatPipe";
        if (verbose) {
            System.err.println("Creating server with UUID " + uuid);
        }
        StreamConnectionNotifier service = (StreamConnectionNotifier)Connector.open((String)url);
        ServiceRecord rec = LocalDevice.getLocalDevice().getRecord((Connection)service);
        String remoteUrl = rec.getConnectionURL(0, false);
        remoteUrl = remoteUrl.substring(0, remoteUrl.indexOf(";"));
        if (verbose) {
            System.err.println("#" + new Date() + " - Listening at " + remoteUrl);
        }
        RFCOMMServer.handleStreamConnection(service, exec, verbose, keepalive, zip);
    }

    public static void startServerChannel(String exec, String port, boolean verbose, boolean keepalive, boolean zip) throws IOException {
        String url = "btspp://localhost:" + port + ";name=BlueCatPipe";
        if (verbose) {
            System.err.println("#Creating server on channel " + port);
        }
        StreamConnectionNotifier service = (StreamConnectionNotifier)Connector.open((String)url);
        ServiceRecord rec = LocalDevice.getLocalDevice().getRecord((Connection)service);
        String remoteUrl = rec.getConnectionURL(0, false);
        remoteUrl = remoteUrl.substring(0, remoteUrl.indexOf(";"));
        if (verbose) {
            System.err.println("#" + new Date() + " - Listening at " + remoteUrl);
        }
        RFCOMMServer.handleStreamConnection(service, exec, verbose, keepalive, zip);
    }

    private static void handleStreamConnection(StreamConnectionNotifier service, String exec, boolean verbose, boolean keepalive, boolean zip) throws IOException {
        do {
            StreamConnection con = service.acceptAndOpen();
            if (verbose) {
                System.err.println("#" + new Date() + " - Connection Received!");
            }
            if (!"".equals(exec)) {
                RFCOMMServer.handleStreamConnectionProcess(con, exec, verbose, zip);
                continue;
            }
            RFCOMMServer.handleStreamConnectionConsole(con, verbose, zip);
        } while (keepalive);
    }

    private static void handleStreamConnectionConsole(StreamConnection con, boolean verbose, boolean zip) throws IOException {
        FilterInputStream is;
        FilterOutputStream os;
        if (verbose) {
            System.err.println("#" + new Date() + " - Standard Console Connection");
        }
        if (verbose && zip) {
            System.err.println("#Zip Mode");
        }
        if (zip) {
            os = new GZIPOutputStream(con.openDataOutputStream());
            is = new GZIPInputStream(con.openDataInputStream());
        } else {
            os = con.openDataOutputStream();
            is = con.openDataInputStream();
        }
        new Thread(new Runnable(){

            @Override
            public void run() {
                try {
                    int bytesRead;
                    byte[] buffer = new byte[1024];
                    while ((bytesRead = is.read(buffer)) != -1) {
                        System.out.write(buffer, 0, bytesRead);
                        System.out.flush();
                    }
                }
                catch (IOException e) {
                    System.err.println("#Error: " + e.getMessage());
                    e.printStackTrace();
                }
            }
        }).start();
        try {
            int bytesRead;
            byte[] buffer = new byte[1024];
            while ((bytesRead = System.in.read(buffer)) != -1) {
                ((OutputStream)os).write(buffer, 0, bytesRead);
                ((OutputStream)os).flush();
            }
        }
        catch (IOException e) {
            System.err.println("#Error: " + e.getMessage());
            e.printStackTrace();
        }
        con.close();
        if (verbose) {
            System.err.println("#" + new Date() + " - Connection Closed");
        }
    }

    private static void handleStreamConnectionProcess(StreamConnection con, String exec, boolean verbose, boolean zip) throws IOException {
        FilterInputStream sis;
        FilterOutputStream sos;
        InputStream err;
        InputStream is;
        OutputStream os;
        if (verbose) {
            System.err.println("#" + new Date() + " - Process Redirect Connection: " + exec);
        }
        if (verbose && zip) {
            System.err.println("#Zip Mode");
        }
        Process p = Runtime.getRuntime().exec(exec);
        if (zip) {
            os = new GZIPOutputStream(p.getOutputStream());
            is = new GZIPInputStream(p.getInputStream());
            err = new GZIPInputStream(p.getErrorStream());
            sos = new GZIPOutputStream(con.openDataOutputStream());
            sis = new GZIPInputStream(con.openDataInputStream());
        } else {
            os = p.getOutputStream();
            is = p.getInputStream();
            err = p.getErrorStream();
            sos = con.openDataOutputStream();
            sis = con.openDataInputStream();
        }
        new Thread(new Runnable(){

            @Override
            public void run() {
                try {
                    int bytesRead;
                    byte[] buffer = new byte[1024];
                    while ((bytesRead = is.read(buffer)) != -1) {
                        sos.write(buffer, 0, bytesRead);
                        sos.flush();
                    }
                }
                catch (IOException e) {
                    e.printStackTrace();
                }
            }
        }).start();
        new Thread(new Runnable(){

            @Override
            public void run() {
                try {
                    int bytesRead;
                    byte[] buffer = new byte[1024];
                    while ((bytesRead = err.read(buffer)) != -1) {
                        sos.write(buffer, 0, bytesRead);
                        sos.flush();
                    }
                }
                catch (IOException e) {
                    e.printStackTrace();
                }
            }
        }).start();
        try {
            int bytesRead;
            byte[] buffer = new byte[1024];
            while ((bytesRead = ((InputStream)sis).read(buffer)) != -1) {
                os.write(buffer, 0, bytesRead);
                os.flush();
            }
            p.destroy();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }
}

