/*
 * Decompiled with CFR 0.152.
 */
import java.io.IOException;
import java.util.Arrays;
import java.util.LinkedList;
import javax.bluetooth.BluetoothStateException;

public class Main {
    public static void main(String[] args1) throws IOException, InterruptedException {
        try {
            LinkedList<String> arg = new LinkedList<String>(Arrays.asList(args1));
            boolean verbose = false;
            if (arg.remove("-v")) {
                verbose = true;
            }
            boolean keepalive = false;
            if (arg.remove("-k")) {
                keepalive = true;
            }
            boolean zip = false;
            if (arg.remove("-z")) {
                zip = true;
            }
            String exec = "";
            if (arg.contains("-e")) {
                int index = arg.indexOf("-e");
                while (index != arg.size() - 1) {
                    exec = String.valueOf(exec) + (String)arg.get(index + 1) + " ";
                    arg.remove(index + 1);
                }
                arg.remove(index);
            }
            if (arg.size() == 0) {
                Main.printUsage();
            }
            if ("devices".equalsIgnoreCase((String)arg.get(0))) {
                RemoteDeviceDiscovery.runDiscovery(verbose);
                System.exit(0);
            }
            if ("doctor".equalsIgnoreCase((String)arg.get(0))) {
                BluCatUtil.doctorDevice();
                System.exit(0);
            }
            if ("services".equalsIgnoreCase((String)arg.get(0))) {
                ListServices.listServices(verbose);
                System.exit(0);
            }
            if (arg.size() == 1 && "-l".equalsIgnoreCase((String)arg.get(0))) {
                RFCOMMServer.startServerRFCOMM(exec, verbose, keepalive, zip);
                System.exit(0);
            }
            if (arg.size() == 2 && "scan".equalsIgnoreCase((String)arg.get(0))) {
                ScanServices.scanDevice((String)arg.get(1));
                System.exit(0);
            }
            if (arg.size() == 2 && "-l".equalsIgnoreCase((String)arg.get(0))) {
                RFCOMMServer.startServerChannel(exec, (String)arg.get(1), verbose, keepalive, zip);
                System.exit(0);
            }
            if (arg.size() == 2 && "-uuid".equalsIgnoreCase((String)arg.get(0))) {
                RFCOMMServer.startServerUuid(exec, (String)arg.get(1), verbose, keepalive, zip);
                System.exit(0);
            }
            if (arg.size() == 2 && "-url".equalsIgnoreCase((String)arg.get(0))) {
                RFCOMMClient.startClient((String)arg.get(1), verbose, zip);
                System.exit(0);
            }
            Main.printUsage();
        }
        catch (BluetoothStateException e) {
            String msg = e.getMessage();
            System.err.println("Error: " + msg);
            if (msg.contains("Bluetooth Device is not available")) {
                System.err.println("!!Is there a device plugged in?");
            }
            BluCatUtil.doctorDevice();
        }
        catch (Exception e) {
            System.err.println("Error: " + e.getMessage());
            e.printStackTrace();
        }
    }

    private static void printUsage() {
        System.out.println("blucat - by Joseph Paul Cohen 2012 - josephpcohen.com\n-_-_-_-_-_-_-_,------,\n_-_-_-_-_-_-_-|   /\\_/\\\n-_-_-_-_-_-_-~|__( ^ .^)\n              \"\"  \"\"\nUsage:\n  blucat devices : Lists devices \n  blucat services : Lists all RFCOMM services \n  blucat services <device> : List RFCOMM services for one device\n  blucat scan <device> : Scan all RFCOMM channels\n  blucat -l : Listen for RFCOMM connection \n  blucat -l <port> : Listen for RFCOMM connection on port\n  blucat -uuid <uuid> : Listen for UUID and attempt RFCOMM\n  blucat -l <port> -e <command>: Listen for RFCOMM connection, execute <command> when connection\n  blucat <server args> -k : Keep the connection alive\n  blucat -url <url> : Connect to RFCOMM URL \n  blucat doctor : Run this if it's not working \n");
        System.exit(0);
    }
}

