/*
 * Decompiled with CFR 0.152.
 */
import com.intel.bluetooth.BluetoothConsts;
import java.io.IOException;
import java.util.Date;
import java.util.HashSet;
import java.util.Set;
import javax.bluetooth.DataElement;
import javax.bluetooth.DeviceClass;
import javax.bluetooth.DiscoveryListener;
import javax.bluetooth.LocalDevice;
import javax.bluetooth.RemoteDevice;
import javax.bluetooth.ServiceRecord;
import javax.bluetooth.UUID;

public class ListServices {
    static final Object serviceSearchCompletedEvent = new Object();

    public static void listServices(String target) throws IOException, InterruptedException {
    }

    public static void listServices(boolean verbose) throws IOException, InterruptedException {
        System.out.println("#Listing all services");
        Set<ServiceRecord> records = ListServices.findViaSDP(verbose);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    static Set<ServiceRecord> findViaSDP(boolean verbose) throws IOException, InterruptedException {
        HashSet<ServiceRecord> toReturn = new HashSet<ServiceRecord>();
        UUID[] uuidSet = new UUID[]{BluetoothConsts.RFCOMM_PROTOCOL_UUID};
        int[] attrIDs = new int[]{256, 3};
        RemoteDeviceDiscovery.findDevices();
        Set<RemoteDevice> devices = RemoteDeviceDiscovery.getDevices();
        for (RemoteDevice remote : devices) {
            Object object = serviceSearchCompletedEvent;
            synchronized (object) {
                System.out.println("#Searching for services on ");
                System.out.println("+," + RemoteDeviceDiscovery.deviceName(remote, verbose));
                LocalDevice.getLocalDevice().getDiscoveryAgent().searchServices(attrIDs, uuidSet, remote, (DiscoveryListener)new ServiceDiscoveryListener(toReturn, verbose));
                serviceSearchCompletedEvent.wait();
            }
        }
        return toReturn;
    }

    private static void printServiceRecord(ServiceRecord rec, boolean verbose) {
        try {
            String url;
            String name = "";
            if (rec.getAttributeValue(256) != null) {
                name = "" + rec.getAttributeValue(256).getValue();
            }
            String desc = "";
            if (rec.getAttributeValue(3) != null) {
                desc = "" + rec.getAttributeValue(3).getValue();
            }
            if ((url = rec.getConnectionURL(0, false)) != null) {
                url = url.substring(0, url.indexOf(";"));
            }
            String remoteMac = rec.getHostDevice().getBluetoothAddress();
            String remoteName = rec.getHostDevice().getFriendlyName(false);
            System.out.print("-," + new Date().getTime() + ", \"" + BluCatUtil.clean(remoteMac) + "\", \"" + BluCatUtil.clean(remoteName) + "\", ");
            System.out.println("\"" + BluCatUtil.clean(name) + "\", \"" + BluCatUtil.clean(desc) + "\", " + BluCatUtil.clean(url));
            if (verbose) {
                System.out.println("#   Attributes Returned " + rec.getAttributeIDs().length);
                int[] nArray = rec.getAttributeIDs();
                int n = nArray.length;
                int n2 = 0;
                while (n2 < n) {
                    int i = nArray[n2];
                    DataElement val = rec.getAttributeValue(i);
                    String sval = val.toString();
                    System.out.println("#  " + String.format("0x%04x", i) + "=" + sval);
                    ++n2;
                }
            }
        }
        catch (Exception e) {
            System.out.println("#Error: " + e.getMessage());
            e.printStackTrace();
        }
    }

    static class ServiceDiscoveryListener
    implements DiscoveryListener {
        Set<ServiceRecord> toReturn;
        boolean verbose;

        public ServiceDiscoveryListener(Set<ServiceRecord> toReturn, boolean verbose) {
            this.toReturn = toReturn;
            this.verbose = verbose;
        }

        public void deviceDiscovered(RemoteDevice arg0, DeviceClass arg1) {
        }

        public void inquiryCompleted(int arg0) {
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void serviceSearchCompleted(int arg0, int arg1) {
            Object object = serviceSearchCompletedEvent;
            synchronized (object) {
                serviceSearchCompletedEvent.notifyAll();
            }
        }

        public void servicesDiscovered(int arg0, ServiceRecord[] arg1) {
            ServiceRecord[] serviceRecordArray = arg1;
            int n = arg1.length;
            int n2 = 0;
            while (n2 < n) {
                ServiceRecord servRec = serviceRecordArray[n2];
                ListServices.printServiceRecord(servRec, this.verbose);
                this.toReturn.add(servRec);
                ++n2;
            }
        }
    }
}

